<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN908500NL - AssignedDevice TKID Assignment</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN908500NL-wrapper">
        <param name="element" value="hl7:PRPM_IN908500NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN908500NL-controlAct">
        <param name="element" value="hl7:PRPM_IN908500NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN908500NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN908500NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN908500NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN908500NL/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De zender van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN908500NL/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/AssignedDevice</title>
        <rule context="hl7:subject/hl7:AssignedDevice/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >assignedDevice/id/@root moet '2.16.840.1.113883.2.4.6.6' bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/assignedDevice/subjectOf2/verficationEvent</title>
        <rule context="hl7:subject/hl7:assignedDevice/hl7:subjectOf2/hl7:verficationEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.5'"
                >verficationEvent/id moet '2.16.840.1.113883.2.4.3.11.5' (XIS-typekwalificatie-id) zijn</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedDevice/hl7:subjectOf2/hl7:verficationEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.2' and @code='XTK'"
                >verficationEvent/code moet 'XTK' zijn en komen uit '2.16.840.1.113883.2.4.3.11.2' (XIS-typekwalificatietypen)</assert>
        </rule>
    </pattern>

</schema>
